package edu.columbia.cs.itx.dsadmin;

import javax.swing.*;
import oracle.jdeveloper.layout.*;
import java.awt.*;
import java.awt.event.*;

public class LoginDialog extends JDialog {
  JPanel dialogPanel = new JPanel();
  BoxLayout2 boxLayout21 = new BoxLayout2();
  JPanel fieldPanel = new JPanel();
  JPanel buttonPanel = new JPanel();
  JButton submitButton = new JButton();
  JButton resetButton = new JButton();
  JLabel idLabel = new JLabel();
  JTextField idField = new JTextField();
  JPasswordField passField = new JPasswordField();
  JLabel passLabel = new JLabel();
  GridBagLayout gridBagLayout1 = new GridBagLayout();

  
  public LoginDialog(Frame parent, String title, boolean modal) {
    super(parent, title, modal);
    try  {
      jbInit();
      pack();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    dialogPanel.setLayout(boxLayout21);
    boxLayout21.setAxis(BoxLayout.Y_AXIS);
    submitButton.setText("Submit");
    resetButton.setText("Reset");
    resetButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        resetID();
        resetPass();
      }
    });
    idLabel.setText("UserID");
    idField.setColumns(20);
    passField.setColumns(20);
    passLabel.setText("Password");
    fieldPanel.setLayout(gridBagLayout1);
    getContentPane().add(dialogPanel);
    dialogPanel.add(fieldPanel, null);
    JLabel[] labels = {idLabel, passLabel};
    JTextField[] textFields = {idField, passField};
    addLabelTextRows(labels, textFields, gridBagLayout1, fieldPanel);
    dialogPanel.add(buttonPanel, null);
    buttonPanel.add(submitButton, null);
    buttonPanel.add(resetButton, null);

  }

  
  public LoginDialog() {
    this(null, "", false);
  }

  private void addLabelTextRows(JLabel[] labels, JTextField[] textFields,
  GridBagLayout gridbag, Container container) {
    GridBagConstraints c = new GridBagConstraints();
    c.anchor = GridBagConstraints.EAST;
    int numLabels = labels.length;

    for (int i = 0; i < numLabels; i++) {
      c.gridwidth = GridBagConstraints.RELATIVE;
      c.fill = GridBagConstraints.NONE;
      c.weightx = 0.0;
      gridbag.setConstraints(labels[i], c);
      container.add(labels[i]);

      c.gridwidth = GridBagConstraints.REMAINDER;
      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      gridbag.setConstraints(textFields[i], c);
      container.add(textFields[i]);
    }
  }

  public String getID() {
    return idField.getText();
  }

  public String getPass() {
    return new String(passField.getPassword());
  }

  public void setFieldListener(ActionListener l) {
    idField.addActionListener(l);
    passField.addActionListener(l);
  }

  public void setSubmitListener(ActionListener l) {
    submitButton.addActionListener(l);
  }

  public void resetID() {
    idField.setText("");
  }

  public void resetPass() {
    passField.setText("");
  }
}

